/******************************************************************************/
class VarPointLight : VarBase
{
public:
            VarPointLight();
   virtual ~VarPointLight();
   
   virtual void create(Object &obj); 
   
   // Setters
   void SetPower (flt value) { m_Power  = value; }
   void SetVol   (flt value) { m_Vol    = value; }
   void SetVolMax(flt value) { m_VolMax = value; }
   void SetPos   (Vec value) { m_Pos    = value; }
   void SetColor (Vec value) { m_Color  = value; }
   void SetDraw  (bool draw) { m_Draw   = draw;  }
   
   // Getters
   Flt  GetPower () { return m_Power;  }
   Flt  GetVol   () { return m_Vol;    }
   Flt  GetVolMax() { return m_VolMax; }
   Vec  GetPos   () { return m_Pos;    }
   Vec  GetColor () { return m_Color;  }
   bool GetDraw  () { return m_Draw;   }
   
private:

   Flt  m_Power , // power             , (0..Inf), determines light range
        m_Vol   , // volumetric amount , (0..Inf)
        m_VolMax; // volumetric maximum, (0..1  )
   Vec  m_Pos  ,  // position          ,
        m_Color;  // color             , (0,0,0) .. (1,1,1)    
   bool m_Draw;

}
/******************************************************************************/
VarPointLight::VarPointLight() : m_Draw(false), m_Power(0), m_Vol(0), m_VolMax(0), m_Pos(0), m_Color(0)                   
{
   
}
VarPointLight::~VarPointLight()
{
   
}
/******************************************************************************/
void VarPointLight::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("Color"))    m_Color = p.asColor().asVec();
   if(Param *p = obj.findParam("Position")) m_Pos = p.asVec();
   if(Param *p = obj.findParam("Power"))    m_Power = p.asFlt();
   if(Param *p = obj.findParam("Vol"))      m_Vol = p.asFlt();
   if(Param *p = obj.findParam("VolMax"))   m_VolMax = p.asFlt();
   
   super.create(obj);
}